/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.common;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public final class ExternalLinksUtils {
    private static final String GENERATION_MSX_URL = "http://www.generation-msx.nl/msxdb/softwareinfo/";
    private static final int GEN_MSX_NON_EXISTING_CODES_START = 10000;
    private static final String YOUTUBE_URL = "https://www.youtube.com/results?search_query=MSX";

    public static boolean isGenerationMSXIdValid(int id) {
        return id > 0 && id < 10000;
    }

    public static String getGenerationMSXURL(int id) {
        return GENERATION_MSX_URL + id;
    }

    public static String getYouTubeSearchURL(String gameName) {
        return "https://www.youtube.com/results?search_query=MSX+" + gameName.replace(" ", "+").replaceAll("\\&", "%26");
    }

    public static void startBrowser(URI uri) throws IOException {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.OPEN)) {
            desktop.browse(uri);
        }
    }

    public static void startBrowser(String address) throws IOException {
        try {
            URI uri = new URI(address);
            ExternalLinksUtils.startBrowser(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }
}

